<?php

class EWRporta_Model_Cache extends XenForo_Model
{
	public function getCaches()
	{
		return $this->fetchAllKeyed("
			SELECT * FROM EWRporta_cache
		", 'module_name');
	}

	public function getCacheByName($modName)
	{
		if (!$cache = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_cache
			WHERE module_name = ?
		", $modName))
		{
			return false;
		}

		return $cache;
	}

	public function buildModuleCache($module, $settings)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Cache', XenForo_DataWriter::ERROR_SILENT);
		if ($cache = $this->getCacheByName($module['module_name']))
		{
			$dw->setExistingData($cache);
		}
		else
		{
			$dw->set('module_name', $module['module_name']);
		}
		$dw->set('module_settings', $settings);
		$dw->save();

		return true;
	}

	public function emptyModuleCache($module)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Cache');
		if ($cache = $this->getCacheByName($module['module_name']))
		{
			$dw->setExistingData($cache);
		}
		else
		{
			return false;
		}
		$dw->delete();

		return true;
	}
}